package gov.va.vamf.scheduling.direct.testutility;

import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.propertyeditors.CustomDateEditor;

import java.text.SimpleDateFormat;
import java.util.Date;

public class CustomDateEditorRegistrar implements PropertyEditorRegistrar {

    @Override
    public void registerCustomEditors(PropertyEditorRegistry registry) {
        registry.registerCustomEditor(Date.class, new CustomDateEditor(new SimpleDateFormat("MM/dd/yyyy hh:mm:ss"), true));
        registry.registerCustomEditor(com.agilex.healthcare.mobilehealthplatform.domain.DOBDate.class,
            new com.agilex.healthcare.utility.CustomDOBDateEditor("MM/dd/yyyy"));
    }
}

